<?php

namespace App\Http\Controllers;

use App\Models\ContactMessage;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class PageController extends Controller
{
    public function home()
    {
        return view('pages.home');
    }

    public function services()
    {
        return view('pages.services');
    }

    public function about()
    {
        return view('pages.about');
    }

    public function contact()
    {
        return view('pages.contact');
    }

    public function projects()
    {
        return view('pages.projects');
    }

    /*
    |--------------------------------------------------------------------------
    | Handle Contact Form Submission
    |--------------------------------------------------------------------------
    */
    public function submitContact(Request $request)
    {
        if (!empty($request->company_website)) {
            return redirect()->back();
        }

        $validated = $request->validate([
            'name'    => 'required|string|max:255',
            'email'   => 'required|email|max:255',
            'subject' => 'required|string|max:255',
            'body'    => 'required|string|min:10',
            'service' => 'nullable|string|max:255',
        ]);

        ContactMessage::create($validated);

        Mail::send('emails.contact', $validated, function ($mail) use ($validated) {
            $mail->to(config('mail.from.address'))
                ->replyTo($validated['email'], $validated['name'])
                ->subject('New Service Request: ' . ($validated['service'] ?? $validated['subject']));
        });

        Mail::send('emails.contact-autoreply', $validated, function ($mail) use ($validated) {
            $mail->to($validated['email'], $validated['name'])
                ->subject('We received your request – Horizon Cee');
        });

        return back()->with('success', 'Your message has been sent successfully.');
    }

}
