document.addEventListener('DOMContentLoaded', () => {
    const hash = window.location.hash;
    if (!hash) return;

    const target = document.querySelector(hash);
    if (!target) return;

    const header = document.querySelector('nav'); // navbar
    // const headerOffset = header ? header.offsetHeight + 20 : 120;
    const headerOffset = header ? header.offsetHeight + 50 : 120;

    const elementTop = target.getBoundingClientRect().top + window.pageYOffset;
    const offsetTop = elementTop - headerOffset;

    // Scroll AFTER page paints (important on refresh)
    setTimeout(() => {
        window.scrollTo({
            top: offsetTop,
            behavior: 'smooth'
        });
    }, 150);

    const serviceBlock = target.querySelector('.service-block');
    if (!serviceBlock) return;

    setTimeout(() => {
        serviceBlock.classList.add('service-focus');

        setTimeout(() => {
            serviceBlock.classList.remove('service-focus');
        }, 3500);
    }, 600);
});


