<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    {{-- Page Title --}}
    <title>@yield('title', 'Engineering Services in Nigeria') | Cee Horizon</title>

    <!-- FAVICONS -->
    <link rel="icon" type="image/x-icon" href="{{ asset('favicons/favicon.ico') }}">
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('favicons/favicon-32x32.png') }}">
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('favicons/favicon-16x16.png') }}">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('favicons/apple-touch-icon.png') }}">
    <link rel="manifest" href="{{ asset('favicons/site.webmanifest') }}">

    <meta name="theme-color" content="#0d6efd">


    {{-- SEO Meta (page-specific) --}}
    @yield('meta')

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Global Styles -->
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">

    {{-- Page-specific styles --}}
    @stack('styles')
</head>
<body>

    {{-- Global Page Preloader --}}
    <div id="page-preloader">
        <div class="spinner"></div>
    </div>

    {{-- Navbar --}}
    @include('partials.navbar')

    <main>
        @yield('content')
    </main>

    {{-- Footer --}}
    @include('partials.footer')

    <!-- WhatsApp Floating Button -->
    <a href="https://wa.me/2348167481877"
       class="whatsapp-float"
       target="_blank"
       aria-label="Chat with us on WhatsApp">
       <i class="bi bi-whatsapp"></i>
    </a>

    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Unified Custom JS -->
    <script src="{{ asset('js/main.js') }}"></script>

    {{-- Page-specific scripts --}}
    @yield('scripts')
</body>
</html>
