@extends('layouts.app')

@push('styles')
<link rel="stylesheet" href="{{ asset('css/projects.css') }}">
@endpush

@section('title', 'Completed Solar, CCTV & Electrical Projects in Nigeria | Cee Horizon')

@section('meta')
<meta name="description" content="Explore completed solar installations, CCTV systems, electrical wiring, and satellite TV projects delivered by Cee Horizon across Nigeria. Professional workmanship you can trust.">
<meta name="keywords" content="solar installation projects Nigeria, CCTV installation projects, electrical wiring projects, satellite TV installations, Cee Horizon projects, engineering projects Nigeria">
<meta name="robots" content="index, follow">

<!-- Open Graph / Facebook & WhatsApp -->
<meta property="og:title" content="Completed Solar, CCTV & Electrical Projects in Nigeria">
<meta property="og:description" content="View professional solar, CCTV, electrical wiring, and satellite TV installations completed by Cee Horizon across Nigeria.">
<meta property="og:type" content="website">
<meta property="og:url" content="{{ url()->current() }}">
<meta property="og:image" content="{{ asset('images/company-intro.jpg') }}">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Completed Solar, CCTV & Electrical Projects in Nigeria">
<meta name="twitter:description" content="Browse our completed solar, CCTV, electrical, and satellite TV projects delivered with precision and reliability across Nigeria.">
<meta name="twitter:image" content="{{ asset('images/company-intro.jpg') }}">
@endsection


@section('content')


<!-- PROJECTS PAGE HERO -->
<section class="hero-section hero-inner position-relative">
    <!-- Hero Image -->
    <img 
        src="{{ asset('images/projects-hero.webp') }}"
        alt="Completed solar, CCTV, satellite and electrical installation projects by Cee Horizon in Nigeria"
        loading="eager"
        fetchpriority="high"
        class="hero-img"
    />

    <!-- Dark overlay for readability -->
    <div class="hero-overlay"></div>

    <div class="container">
        <div class="row">
            <div class="col-lg-7 hero-content">
                <h1 class="fw-bold display-3 hero-title">
                    Our Completed Projects
                </h1>
                <p class="lead mt-3 hero-text">
                    Explore a selection of our professional installations, from solar systems and CCTV cameras to satellite TV and complete house wiring.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- FILTER BUTTONS -->
<section class="projects-page reveal">
    <div class="container">

        <div class="text-center mb-4 reveal">
            <button class="btn btn-outline-primary me-2 filter-btn active" data-filter="all">All</button>
            <button class="btn btn-outline-primary me-2 filter-btn" data-filter="solar">Solar</button>
            <button class="btn btn-outline-primary me-2 filter-btn" data-filter="cctv">CCTV</button>
            <button class="btn btn-outline-primary me-2 filter-btn" data-filter="electrical">Electrical</button>
            <button class="btn btn-outline-primary filter-btn" data-filter="satellite">Satellite TV</button>
        </div>

        <!-- PROJECTS GRID -->
        <div class="row g-4" id="projects-grid">

            <!-- Project Items -->
            <div class="col-sm-6 col-md-4 col-lg-3 project-item" data-category="solar">
                <div class="project-card">
                    <img src="{{ asset('images/project-solar-2.webp') }}" alt="Completed residential solar installation in Nigeria by Cee Horizon"
                         class="img-fluid project-img" data-bs-toggle="modal" data-bs-target="#projectModal"
                         data-title="Solar Installation" data-img="{{ asset('images/company-intro.jpg') }}">
                    <div class="project-info mt-2">
                        <h6>Solar Installation</h6>
                        <span>Residential Project</span>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-4 col-lg-3 project-item" data-category="cctv">
                <div class="project-card">
                    <img src="{{ asset('images/project-cctv.webp') }}" alt="Complete office building CCTV camera installation in Nigeria by Cee Horizon"
                         class="img-fluid project-img" data-bs-toggle="modal" data-bs-target="#projectModal"
                         data-title="CCTV Camera Setup" data-img="{{ asset('images/company-intro.jpg') }}">
                    <div class="project-info mt-2">
                        <h6>CCTV Camera Setup</h6>
                        <span>Office Security</span>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-4 col-lg-3 project-item" data-category="electrical">
                <div class="project-card">
                    <img src="{{ asset('images/project-electrical.webp') }}" alt="Completed electrical wiring project in a Nigerian home by Cee Horizon"
                         class="img-fluid project-img" data-bs-toggle="modal" data-bs-target="#projectModal"
                         data-title="Electrical Wiring" data-img="{{ asset('images/company-intro.jpg') }}">
                    <div class="project-info mt-2">
                        <h6>Electrical Wiring</h6>
                        <span>Complete Building</span>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-4 col-lg-3 project-item" data-category="satellite">
                <div class="project-card">
                    <img src="{{ asset('images/project-satellite.webp') }}" alt="Completed satellite TV installation in a Nigerian home by Cee Horizon"
                         class="img-fluid project-img" data-bs-toggle="modal" data-bs-target="#projectModal"
                         data-title="Satellite TV Installation" data-img="{{ asset('images/company-intro.jpg') }}">
                    <div class="project-info mt-2">
                        <h6>Satellite TV Installation</h6>
                        <span>Residential Project</span>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-4 col-lg-3 project-item" data-category="solar">
                <div class="project-card">
                    <img src="{{ asset('images/project-solar.webp') }}" alt="Completed residential solar installation in Nigeria by Cee Horizon"
                         class="img-fluid project-img" data-bs-toggle="modal" data-bs-target="#projectModal"
                         data-title="Solar Installation" data-img="{{ asset('images/company-intro.jpg') }}">
                    <div class="project-info mt-2">
                        <h6>Solar Installation</h6>
                        <span>Residential Project</span>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-4 col-lg-3 project-item" data-category="cctv">
                <div class="project-card">
                    <img src="{{ asset('images/project-cctv-2.webp') }}" alt="Complete Residential CCTV camera installation in Nigeria by Cee Horizon"
                         class="img-fluid project-img" data-bs-toggle="modal" data-bs-target="#projectModal"
                         data-title="CCTV Camera Setup" data-img="{{ asset('images/company-intro.jpg') }}">
                    <div class="project-info mt-2">
                        <h6>CCTV Camera Setup</h6>
                        <span>House Security</span>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-4 col-lg-3 project-item" data-category="electrical">
                <div class="project-card">
                    <img src="{{ asset('images/project-electrical-2.webp') }}" alt="Completed electrical wiring project in a Nigerian home by Cee Horizon"
                         class="img-fluid project-img" data-bs-toggle="modal" data-bs-target="#projectModal"
                         data-title="Electrical Wiring" data-img="{{ asset('images/company-intro.jpg') }}">
                    <div class="project-info mt-2">
                        <h6>Electrical Wiring</h6>
                        <span>Complete Building</span>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-4 col-lg-3 project-item" data-category="satellite">
                <div class="project-card">
                    <img src="{{ asset('images/project-satellite-2.webp') }}" alt="Completed satellite TV installation in a Nigerian office building by Cee Horizon"
                         class="img-fluid project-img" data-bs-toggle="modal" data-bs-target="#projectModal"
                         data-title="Satellite TV Installation" data-img="{{ asset('images/company-intro.jpg') }}">
                    <div class="project-info mt-2">
                        <h6>Satellite TV Installation</h6>
                        <span>Commercial Project</span>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-4 col-lg-3 project-item" data-category="solar">
                <div class="project-card">
                    <img src="{{ asset('images/project-solar-3.webp') }}" alt="Completed commercial solar installation in Achi Mbieri Mbaitoli, Owerri by Cee Horizon"
                         class="img-fluid project-img" data-bs-toggle="modal" data-bs-target="#projectModal"
                         data-title="Solar Installation" data-img="{{ asset('images/company-intro.jpg') }}">
                    <div class="project-info mt-2">
                        <h6>Solar Installation</h6>
                        <span>Commercial Project</span>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- CTA SECTION FULL-WIDTH -->
<section class="cta-section text-center text-white reveal">
    <div class="container py-5">
        <h2 class="mb-3">Interested in working with us?</h2>
        <p class="mb-4">Contact us today to discuss your project and see how we can help.</p>
        <a href="{{ route('contact') }}" class="btn btn-accent btn-lg">Get in Touch</a>
    </div>
</section>

<!-- PROJECT LIGHTBOX MODAL -->
<div class="modal fade" id="projectModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content border-0 position-relative">
      <button type="button" class="btn-close position-absolute top-0 end-0 m-3" data-bs-dismiss="modal" aria-label="Close"></button>
      <button type="button" class="position-absolute top-50 start-0 translate-middle-y btn btn-dark btn-sm px-3" id="prevProject">&#10094;</button>
      <button type="button" class="position-absolute top-50 end-0 translate-middle-y btn btn-dark btn-sm px-3" id="nextProject">&#10095;</button>
      <div class="modal-header border-0">
        <h5 class="modal-title" id="projectModalLabel"></h5>
      </div>
      <div class="modal-body p-0">
        <img src="" alt="" id="projectModalImg" class="img-fluid w-100">
      </div>
    </div>
  </div>
</div>

@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
   // ===== Project Filtering with Animation =====
   const filterBtns = document.querySelectorAll('.filter-btn');
   const projectItems = document.querySelectorAll('.project-item');

   const animateVisibleItems = () => {
       projectItems.forEach(item => {
           if (item.style.display !== 'none') {
               item.classList.remove('is-visible');
               void item.offsetWidth;
               item.classList.add('is-visible');
           }
       });
   };

   window.addEventListener('load', animateVisibleItems);

   filterBtns.forEach(btn => {
       btn.addEventListener('click', () => {
           filterBtns.forEach(b => b.classList.remove('active'));
           btn.classList.add('active');

           const filter = btn.dataset.filter;
           projectItems.forEach(item => {
               if (filter === 'all' || item.dataset.category === filter) {
                   item.style.display = '';
               } else {
                   item.style.display = 'none';
                   item.classList.remove('is-visible');
               }
           });

           setTimeout(animateVisibleItems, 50);
       });
   });

   // ===== Modal Lightbox =====
   const projectModal = document.getElementById('projectModal');
   const projectModalLabel = document.getElementById('projectModalLabel');
   const projectModalImg = document.getElementById('projectModalImg');

   let currentIndex = 0;
   let visibleProjects = [];

   const updateVisibleProjects = () => {
       visibleProjects = Array.from(document.querySelectorAll('.project-item'))
           .filter(p => p.style.display !== 'none');
   }

   const openProjectModal = (index) => {
       const item = visibleProjects[index];
       const img = item.querySelector('.project-img');
       projectModalImg.classList.add('fade-out');

       setTimeout(() => {
           projectModalLabel.textContent = img.dataset.title;
           projectModalImg.src = img.dataset.img;
           projectModalImg.classList.remove('fade-out');
           projectModalImg.classList.add('fade-in');
           setTimeout(() => projectModalImg.classList.remove('fade-in'), 300);
       }, 200);

       currentIndex = index;
   }

   document.querySelectorAll('.project-img').forEach(img => {
       img.addEventListener('click', function() {
           updateVisibleProjects();
           const index = visibleProjects.indexOf(this.closest('.project-item'));
           openProjectModal(index);
       });
   });

   document.getElementById('prevProject').addEventListener('click', () => {
       if(visibleProjects.length === 0) return;
       currentIndex = (currentIndex - 1 + visibleProjects.length) % visibleProjects.length;
       openProjectModal(currentIndex);
   });

   document.getElementById('nextProject').addEventListener('click', () => {
       if(visibleProjects.length === 0) return;
       currentIndex = (currentIndex + 1) % visibleProjects.length;
       openProjectModal(currentIndex);
   });

});
</script>
@endsection
