

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/services.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('title', 'Solar, CCTV, Satellite TV & Electrical Services in Nigeria'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="Cee Horizon provides professional solar, inverter, electrical, CCTV, and satellite TV services in Owerri, Imo State, and across Nigeria. Trusted solutions for residential and commercial projects.">
<meta name="keywords" content="Cee Horizon services, solar installation Nigeria, inverter systems, CCTV installation, satellite TV installation, electrical wiring, Owerri, Nigeria, energy solutions">
<meta name="robots" content="index, follow">

<!-- Open Graph / Facebook & WhatsApp -->
<meta property="og:title" content="Solar, CCTV, Satellite TV & Electrical Services in Nigeria | Cee Horizon">
<meta property="og:description" content="Explore Cee Horizon’s professional solar, inverter, electrical, CCTV, and satellite TV services for residential and commercial projects across Nigeria.">
<meta property="og:type" content="website">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">
<meta property="og:image" content="<?php echo e(asset('images/company-intro.jpg')); ?>">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Solar, CCTV, Satellite TV & Electrical Services in Nigeria | Cee Horizon">
<meta name="twitter:description" content="Professional solar, inverter, electrical, CCTV, and satellite TV services in Owerri and across Nigeria by Cee Horizon.">
<meta name="twitter:image" content="<?php echo e(asset('images/company-intro.jpg')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

<!-- SERVICES PAGE HERO -->
<section class="hero-section position-relative">
    <!-- Hero Image -->
    <img 
    src="<?php echo e(asset('images/services-hero.webp')); ?>"
    alt="Professional solar, CCTV, and electrical installation services at a residential home in Nigeria by Cee Horizon"
    loading="eager"
    fetchpriority="high"
    class="img-fluid hero-img"
    />

    <!-- Dark overlay for readability -->
    <div class="hero-overlay"></div>

    <div class="container">
        <div class="row">
            <div class="col-lg-7 hero-content">
                <h1 class="fw-bold display-3 hero-title">
                    Our Professional Services
                </h1>
                <p class="lead mt-3 hero-text">
                    Cee Horizon delivers reliable solar, electrical, CCTV, and satellite solutions designed
                    to meet modern residential and commercial needs anywhere in Nigeria.
                </p>
            </div>
        </div>
    </div>
</section>


<!-- SERVICES INTRO -->
<section class="services-intro reveal">
    <div class="container text-center">
        <h2 class="fw-bold text-primary mb-3">What We Do</h2>
        <p class="lead mx-auto" style="max-width: 820px;">
            Cee Horizon provides end-to-end electrical and energy solutions backed by experience,
            safety standards, and professional workmanship. Whether it’s powering homes,
            securing properties, or delivering uninterrupted entertainment, we do it right nationwide.
        </p>
    </div>
</section>

<!-- SERVICES LIST -->
<section class="services-list">
    <div class="container">
        <div class="row g-5">

            <!-- Service Item: Solar & Inverter -->
            <div class="col-lg-6 reveal" id="solar">
                <div class="service-block">
                    <div class="service-image">
                        <img src="<?php echo e(asset('images/service-solar.webp')); ?>" alt="Solar and inverter installation in progress at a Nigerian home by Cee Horizon">
                    </div>
                    <div class="service-content">
                        <h4 class="fw-bold text-primary">Solar & Inverter Installations</h4>
                        <p>
                            We design and install efficient solar and inverter systems that provide
                            reliable backup power and reduce dependence on the grid.
                        </p>
                        <ul>
                            <li>Residential & commercial installations</li>
                            <li>High-quality panels and inverters</li>
                            <li>System maintenance & upgrades</li>
                        </ul>
                        <a href="<?php echo e(route('contact', ['service' => 'Solar & Inverter Installation'])); ?>" class="btn btn-primary mt-3">Request Service</a>
                    </div>
                </div>
            </div>

            <!-- Service Item: CCTV -->
            <div class="col-lg-6 reveal" id="cctv">
                <div class="service-block">
                    <div class="service-image">
                        <img src="<?php echo e(asset('images/service-cctv.webp')); ?>" alt="CCTV camera installation at a residential home in Nigeria by Cee Horizon">
                    </div>
                    <div class="service-content">
                        <h4 class="fw-bold text-primary">CCTV Camera Installations</h4>
                        <p>
                            Protect your property with professionally installed surveillance systems
                            designed for clear monitoring and long-term reliability.
                        </p>
                        <ul>
                            <li>Indoor & outdoor camera setups</li>
                            <li>Remote monitoring solutions</li>
                            <li>Maintenance & upgrades</li>
                        </ul>
                        <a href="<?php echo e(route('contact', ['service' => 'CCTV Camera Installation'])); ?>" class="btn btn-primary mt-3">Request Service</a>
                    </div>
                </div>
            </div>

            <!-- Service Item: Satellite TV -->
            <div class="col-lg-6 reveal" id="satellite">
                <div class="service-block">
                    <div class="service-image">
                        <img src="<?php echo e(asset('images/service-satellite.webp')); ?>" alt="Satellite TV dish installation at a Nigerian home by Cee Horizon">
                    </div>
                    <div class="service-content">
                        <h4 class="fw-bold text-primary">Satellite TV Installations</h4>
                        <p>
                            Enjoy uninterrupted entertainment with expert satellite TV installations
                            tailored for homes, offices, and commercial spaces.
                        </p>
                        <ul>
                            <li>Professional dish alignment</li>
                            <li>Multi-room configurations</li>
                            <li>Signal troubleshooting</li>
                        </ul>
                        <a href="<?php echo e(route('contact', ['service' => 'Satellite TV Installation'])); ?>" class="btn btn-primary mt-3">Request Service</a>
                    </div>
                </div>
            </div>

            <!-- Service Item: Electrical Wiring -->
            <div class="col-lg-6 reveal" id="electrical">
                <div class="service-block">
                    <div class="service-image">
                        <img src="<?php echo e(asset('images/service-electrical.webp')); ?>" alt="Professional electrical wiring and maintenance in a Nigerian home by Cee Horizon">
                    </div>
                    <div class="service-content">
                        <h4 class="fw-bold text-primary">Electrical Wiring & Maintenance</h4>
                        <p>
                            From complete building wiring to repairs and maintenance, we ensure safe,
                            compliant, and durable electrical installations.
                        </p>
                        <ul>
                            <li>Complete house wiring</li>
                            <li>Fault detection & repairs</li>
                            <li>Electrical upgrades</li>
                        </ul>
                        <a href="<?php echo e(route('contact', ['service' => 'Electrical Wiring & Maintenance'])); ?>" class="btn btn-primary mt-3">Request Service</a>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- SERVICES CTA -->
<section class="services-cta text-center reveal">
    <div class="container">
        <h2 class="fw-bold mb-3">Need a Professional Service?</h2>
        <p class="lead mb-4">
            Get in touch with Cee Horizon today for reliable electrical and energy solutions anywhere in Nigeria.
        </p>
        <a href="<?php echo e(route('contact')); ?>" class="btn btn-light btn-lg">
            Request a Quote
        </a>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('js/services-scroll.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\SOOQ ELASER\Desktop\web-projects\horizon\resources\views\pages\services.blade.php ENDPATH**/ ?>